# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Create a new composed look
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# Name of the composed look
$name = "PowerShell"

# Relative URL to the master page
$masterUrl = "/_catalogs/masterpages/seattle.master"

# Relative URL to color palette
$paletteUrl = "/_catalogs/theme/15/Palette015.spcolor"

# Relative URL to font scheme
$fontUrl = "/_catalogs/theme/15/SharePointPersonality.spfont"

# Relative URL for background image
$backgroundUrl = "/_layouts/15/images/image_bg011.jpg"

# Display order
$displayOrder = 200

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site
$web = Get-SPWeb $webUrl

# Get the Composed Looks list
$list = $web.Lists["Composed Looks"]

# Create a new item
$item = $list.Items.Add()

# Set the item properties
$item["Title"] = $name
$item["Name"] = $name
$item["Master Page URL"] = $masterUrl
$item["Theme URL"] = $paletteUrl
$item["Image URL"] = $backgroundUrl
$item["Font Scheme URL"] = $fontUrl
$item["Display Order"] = $displayOrder

# Update the item
$item.Update()   

# Dispose of the site object
$web.Dispose() 

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 